/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.fishermens_trap.common.blocks;

import com.mojang.datafixers.util.Pair;
import com.uraneptus.fishermens_trap.FTConfig;
import com.uraneptus.fishermens_trap.FishermensTrap;
import com.uraneptus.fishermens_trap.common.blocks.container.FTItemStackHandler;
import com.uraneptus.fishermens_trap.common.blocks.container.FishtrapMenu;
import com.uraneptus.fishermens_trap.core.other.tags.FTBiomeTags;
import com.uraneptus.fishermens_trap.core.other.tags.FTItemTags;
import com.uraneptus.fishermens_trap.core.registry.FTBlockEntityType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FishtrapBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final Component FISHTRAP_NAME = Component.m_237115_((String)"fishermens_trap.container.fishtrap");
    private final FTItemStackHandler handler = new FTItemStackHandler(){

        protected void onContentsChanged(int slot) {
            FishtrapBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> input = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.handler, 0, 1));
    private final LazyOptional<IItemHandler> output = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.handler, 1, 10));
    private int tickCounter = 0;

    public FishtrapBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FTBlockEntityType.FISHTRAP.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("handler", (Tag)this.handler.serializeNBT());
        pTag.m_128405_("tickCounter", this.tickCounter);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.handler.deserializeNBT(pTag.m_128469_("handler"));
        this.tickCounter = pTag.m_128451_("tickCounter");
    }

    private CompoundTag saveItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("handler", (Tag)this.handler.serializeNBT());
        return compound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.saveItems(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public static Pair<Integer, Integer> getMinMaxCounterInts() {
        if (!FMLEnvironment.production) {
            return Pair.of((Object)48, (Object)80);
        }
        return Pair.of((Object)((Integer)FTConfig.MIN_TICKS_TO_FISH.get()), (Object)((Integer)FTConfig.MAX_TICKS_TO_FISH.get()));
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FishtrapBlockEntity pBlockEntity) {
        RandomSource random = pLevel.m_213780_();
        if ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond() > (Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()) {
            if (pBlockEntity.tickCounter >= random.m_216332_(((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()).intValue(), ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond()).intValue())) {
                pBlockEntity.tickCounter = 0;
                if (FishtrapBlockEntity.isValidFishingLocation(pLevel, pPos)) {
                    LootTable loottable;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)pLevel).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81462_, (Object)pBlockEntity).m_230911_(random);
                    ItemStack itemInBaitSlot = pBlockEntity.handler.getStackInSlot(0);
                    if (itemInBaitSlot.m_204117_(FTItemTags.FISH_BAITS) && !itemInBaitSlot.m_150930_(Items.f_41852_)) {
                        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemInBaitSlot.m_41720_());
                        ResourceLocation lootTableLocation = FishermensTrap.modPrefix("gameplay/fishtrap_fishing/" + Objects.requireNonNull(registryName).m_135827_() + "/" + registryName.m_135815_());
                        loottable = pLevel.m_7654_().m_129898_().m_79217_(lootTableLocation);
                    } else {
                        loottable = pLevel.m_7654_().m_129898_().m_79217_(BuiltInLootTables.f_78721_);
                    }
                    ObjectArrayList list = loottable.m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
                    pBlockEntity.handler.handleItemsInsertion((List<ItemStack>)list, itemInBaitSlot, random);
                }
            } else {
                ++pBlockEntity.tickCounter;
            }
        } else {
            FishermensTrap.LOGGER.error("Fish trap ticks: [Min value must be below Max value]");
        }
    }

    private static boolean isValidFishingLocation(Level pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!pLevel.m_8055_(pPos).m_60819_().m_205070_(FluidTags.f_13131_) || !pLevel.m_6425_(pPos.m_121945_(direction)).m_205070_(FluidTags.f_13131_) || !pLevel.m_204166_(pPos).m_203656_(FTBiomeTags.CAN_FISHTRAP_FISH)) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER) && side != null) {
            return side.equals((Object)Direction.UP) ? this.input.cast() : (side.equals((Object)Direction.DOWN) ? this.output.cast() : LazyOptional.empty());
        }
        return super.getCapability(cap, side);
    }

    public FTItemStackHandler getInventory() {
        return this.handler;
    }

    public Component m_7755_() {
        return FISHTRAP_NAME;
    }

    public Component m_5446_() {
        return FISHTRAP_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FishtrapMenu(pContainerId, pPlayerInventory, this.handler);
    }
}

